/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.ommc.api.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.plusls.ommc.api.command.ClientCoordinates;
import com.plusls.ommc.api.command.ClientLocalCoordinates;
import com.plusls.ommc.api.command.ClientWorldCoordinates;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1937;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_638;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.ComponentCompat;

public class ClientBlockPosArgument
implements ArgumentType<ClientCoordinates> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0 0 0", "~ ~ ~", "^ ^ ^", "^1 ^ ^-5", "~0.5 ~1 ~-5");
    public static final SimpleCommandExceptionType ERROR_NOT_LOADED = new SimpleCommandExceptionType((Message)ComponentCompat.translatable((String)"argument.pos.unloaded", (Object[])new Object[0]));
    public static final SimpleCommandExceptionType ERROR_OUT_OF_WORLD = new SimpleCommandExceptionType((Message)ComponentCompat.translatable((String)"argument.pos.outofworld", (Object[])new Object[0]));
    public static final SimpleCommandExceptionType ERROR_OUT_OF_BOUNDS = new SimpleCommandExceptionType((Message)ComponentCompat.translatable((String)"argument.pos.outofbounds", (Object[])new Object[0]));

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static ClientBlockPosArgument blockPos() {
        return new ClientBlockPosArgument();
    }

    public static class_2338 getLoadedBlockPos(@NotNull CommandContext<FabricClientCommandSource> context, String name) throws CommandSyntaxException {
        class_638 clientLevel = ((FabricClientCommandSource)context.getSource()).getWorld();
        return ClientBlockPosArgument.getLoadedBlockPos(context, clientLevel, name);
    }

    public static class_2338 getLoadedBlockPos(CommandContext<FabricClientCommandSource> context, @NotNull class_638 clientLevel, String name) throws CommandSyntaxException {
        class_2338 blockPos = ClientBlockPosArgument.getBlockPos(context, name);
        if (!clientLevel.method_8477(blockPos)) {
            throw ERROR_NOT_LOADED.create();
        }
        if (!clientLevel.method_24794(blockPos)) {
            throw ERROR_OUT_OF_WORLD.create();
        }
        return blockPos;
    }

    public static class_2338 getBlockPos(@NotNull CommandContext<FabricClientCommandSource> commandContext, String string) {
        return ((ClientCoordinates)commandContext.getArgument(string, ClientCoordinates.class)).getBlockPos((FabricClientCommandSource)commandContext.getSource());
    }

    public static class_2338 getSpawnablePos(CommandContext<FabricClientCommandSource> commandContext, String string) throws CommandSyntaxException {
        class_2338 blockPos = ClientBlockPosArgument.getBlockPos(commandContext, string);
        if (!class_1937.method_25953((class_2338)blockPos)) {
            throw ERROR_OUT_OF_BOUNDS.create();
        }
        return blockPos;
    }

    public ClientCoordinates parse(@NotNull StringReader stringReader) throws CommandSyntaxException {
        return stringReader.canRead() && stringReader.peek() == '^' ? ClientLocalCoordinates.parse(stringReader) : ClientWorldCoordinates.parseInt(stringReader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        if (!(commandContext.getSource() instanceof class_2172)) {
            return Suggestions.empty();
        }
        String string = suggestionsBuilder.getRemaining();
        Set<class_2172.class_2173> collection = !string.isEmpty() && string.charAt(0) == '^' ? Collections.singleton(class_2172.class_2173.field_9834) : ((class_2172)commandContext.getSource()).method_17771();
        return class_2172.method_9260((String)string, collection, (SuggestionsBuilder)suggestionsBuilder, (Predicate)class_2170.method_9238(this::parse));
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

