/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.ommc.impl.feature.sortInventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.plusls.ommc.api.sortInventory.IDyeBlock;
import com.plusls.ommc.game.Configs;
import com.plusls.ommc.impl.feature.sortInventory.ShulkerBoxItemHelper;
import com.plusls.ommc.impl.feature.sortInventory.SortInventoryShulkerBoxLastType;
import com.plusls.ommc.mixin.accessor.AccessorAbstractContainerScreen;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_3620;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_636;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.api.compat.minecraft.world.item.ItemStackCompat;

public class SortInventoryHelper {
    public static final int SLOT_CLICKED_OUTSIDE = -999;
    private static boolean allShulkerBox;
    private static final Map<class_1767, Integer> DYE_COLOR_MAPPING;
    private static final Map<class_3620, Integer> MAP_COLOR_MAPPING;

    @Nullable
    public static class_3545<Integer, Integer> getSortRange(class_1703 screenHandler, @NotNull class_1735 mouseSlot) {
        int i;
        int mouseIdx = mouseSlot.field_7874;
        if (mouseIdx == 0 && mouseSlot.method_34266() != 0) {
            mouseIdx = mouseSlot.method_34266();
        }
        int l = mouseIdx;
        int r = mouseIdx + 1;
        Class clazz = ((class_1735)screenHandler.field_7761.get((int)mouseIdx)).field_7871.getClass();
        for (i = mouseIdx - 1; i >= 0; --i) {
            if (clazz != ((class_1735)screenHandler.field_7761.get((int)i)).field_7871.getClass()) {
                l = i + 1;
                break;
            }
            if (i != 0) continue;
            l = 0;
        }
        for (i = mouseIdx + 1; i < screenHandler.field_7761.size(); ++i) {
            if (clazz != ((class_1735)screenHandler.field_7761.get((int)i)).field_7871.getClass()) {
                r = i;
                break;
            }
            if (i != screenHandler.field_7761.size() - 1) continue;
            r = screenHandler.field_7761.size();
        }
        if (mouseSlot.field_7871 instanceof class_1661) {
            if (l == 5 && r == 46) {
                if (mouseIdx >= 9 && mouseIdx < 36) {
                    return new class_3545((Object)9, (Object)36);
                }
                if (mouseIdx >= 36 && mouseIdx < 45) {
                    return new class_3545((Object)36, (Object)45);
                }
                return null;
            }
            if (r - l == 36) {
                if (mouseIdx >= l && mouseIdx < l + 27) {
                    return new class_3545((Object)l, (Object)(l + 27));
                }
                return new class_3545((Object)(l + 27), (Object)r);
            }
        }
        if (l + 1 == r) {
            return null;
        }
        return new class_3545((Object)l, (Object)r);
    }

    @Nullable
    public static Runnable sort() {
        double y;
        class_310 client = class_310.method_1551();
        if (!(client.field_1755 instanceof class_465) || client.field_1755 instanceof class_481) {
            return null;
        }
        class_465 handledScreen = (class_465)client.field_1755;
        class_1041 window = client.method_22683();
        double x = client.field_1729.method_1603() * (double)window.method_4486() / (double)window.method_4480();
        class_1735 mouseSlot = ((AccessorAbstractContainerScreen)handledScreen).invokeFindSlot(x, y = client.field_1729.method_1604() * (double)window.method_4502() / (double)window.method_4507());
        if (mouseSlot == null) {
            return null;
        }
        class_746 player = client.field_1724;
        if (client.field_1761 == null || player == null) {
            return null;
        }
        class_1703 screenHandler = player.field_7512;
        class_3545<Integer, Integer> sortRange = SortInventoryHelper.getSortRange(screenHandler, mouseSlot);
        if (sortRange == null) {
            return null;
        }
        ArrayList itemStacks = Lists.newArrayList();
        class_1799 cursorStack = screenHandler.method_34255().method_7972();
        screenHandler.field_7761.stream().map(slot -> slot.method_7677().method_7972()).forEach(itemStacks::add);
        List<Integer> mergeQueue = SortInventoryHelper.mergeItems(cursorStack, itemStacks, (Integer)sortRange.method_15442(), (Integer)sortRange.method_15441());
        List<class_3545<Integer, Integer>> swapQueue = SortInventoryHelper.quickSort(itemStacks, (Integer)sortRange.method_15442(), (Integer)sortRange.method_15441());
        SortInventoryHelper.doClick((class_1657)player, screenHandler.field_7763, client.field_1761, mergeQueue, swapQueue);
        return !mergeQueue.isEmpty() || !swapQueue.isEmpty() ? () -> class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f)) : () -> class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_14701, (float)1.0f));
    }

    public static void doClick(class_1657 player, int syncId, @NotNull class_636 interactionManager, @NotNull List<Integer> mergeQueue, List<class_3545<Integer, Integer>> swapQueue) {
        for (Integer n : mergeQueue) {
            if (n < 0 && n != -999) {
                interactionManager.method_2906(syncId, -n.intValue(), 1, class_1713.field_7790, player);
                continue;
            }
            interactionManager.method_2906(syncId, n.intValue(), 0, class_1713.field_7790, player);
        }
        for (class_3545 class_35452 : swapQueue) {
            interactionManager.method_2906(syncId, ((Integer)class_35452.method_15442()).intValue(), 0, class_1713.field_7790, player);
            interactionManager.method_2906(syncId, ((Integer)class_35452.method_15441()).intValue(), 0, class_1713.field_7790, player);
            interactionManager.method_2906(syncId, ((Integer)class_35452.method_15442()).intValue(), 0, class_1713.field_7790, player);
        }
    }

    private static boolean canStackAddMore(@NotNull class_1799 existingStack, class_1799 stack) {
        return !existingStack.method_7960() && ItemStackCompat.isSameItemSameTags((class_1799)existingStack, (class_1799)stack) && ShulkerBoxItemHelper.isStackable(existingStack) && existingStack.method_7947() < ShulkerBoxItemHelper.getMaxCount(existingStack) && existingStack.method_7947() < 64;
    }

    @NotNull
    public static List<Integer> addItemStack(List<class_1799> itemStacks, class_1799 stackToAdd, int beginSlot, int endSlot) {
        ArrayList ret = Lists.newArrayList();
        for (int i = beginSlot; i < endSlot; ++i) {
            int addNum;
            class_1799 stack = itemStacks.get(i);
            if (stack.method_7960() || !SortInventoryHelper.canStackAddMore(stack, stackToAdd) || (addNum = ShulkerBoxItemHelper.getMaxCount(stack) - stack.method_7947()) <= 0) continue;
            ret.add(i);
            if (addNum >= stackToAdd.method_7947()) {
                stack.method_7933(stackToAdd.method_7947());
                stackToAdd.method_7934(stackToAdd.method_7947());
                break;
            }
            stack.method_7933(addNum);
            stackToAdd.method_7934(addNum);
        }
        return ret;
    }

    private static int getItemId(@NotNull class_1799 itemStack) {
        return class_1792.method_7880((class_1792)itemStack.method_7909());
    }

    @NotNull
    private static List<class_3545<Integer, Integer>> quickSort(List<class_1799> itemStacks, int startSlot, int endSlot) {
        int i;
        ArrayList ret = Lists.newArrayList();
        ArrayList sortedItemStacks = Lists.newArrayList();
        allShulkerBox = true;
        for (i = startSlot; i < endSlot; ++i) {
            class_1799 itemStack = itemStacks.get(i);
            if (!itemStack.method_7960() && !ShulkerBoxItemHelper.isShulkerBoxBlockItem(itemStack)) {
                allShulkerBox = false;
            }
            sortedItemStacks.add(itemStack);
        }
        sortedItemStacks.sort(new ItemStackComparator());
        for (i = endSlot - 1; i >= startSlot; --i) {
            class_1799 dstStack = (class_1799)sortedItemStacks.get(i - startSlot);
            int dstIdx = -1;
            if (itemStacks.get(i) == dstStack) continue;
            for (int j = startSlot; j < endSlot; ++j) {
                if (itemStacks.get(j) != dstStack) continue;
                dstIdx = j;
                break;
            }
            if (dstIdx == -1) continue;
            if (itemStacks.get(i).method_7947() < dstStack.method_7947()) {
                ret.add(new class_3545((Object)dstIdx, (Object)i));
            } else {
                ret.add(new class_3545((Object)i, (Object)dstIdx));
            }
            itemStacks.set(dstIdx, itemStacks.get(i));
            itemStacks.set(i, dstStack);
        }
        return ret;
    }

    @NotNull
    private static List<Integer> mergeItems(@NotNull class_1799 cursorStack, List<class_1799> targetItemStacks, int beginSlot, int endSlot) {
        int i;
        ArrayList ret = Lists.newArrayList();
        if (!cursorStack.method_7960()) {
            ret.addAll(SortInventoryHelper.addItemStack(targetItemStacks, cursorStack, beginSlot, endSlot));
        }
        for (i = endSlot - 1; i >= beginSlot; --i) {
            class_1799 stack = targetItemStacks.get(i);
            if (stack.method_7960()) continue;
            targetItemStacks.set(i, new class_1799((class_1935)class_2246.field_10124));
            List<Integer> addItemStackClickList = SortInventoryHelper.addItemStack(targetItemStacks, stack, beginSlot, i + 1);
            if (!addItemStackClickList.isEmpty()) {
                ret.add(i);
                ret.addAll(addItemStackClickList);
                if (!stack.method_7960()) {
                    ret.add(i);
                    targetItemStacks.set(i, stack);
                    continue;
                }
                if (cursorStack.method_7960()) continue;
                targetItemStacks.set(i, cursorStack);
                continue;
            }
            targetItemStacks.set(i, stack);
        }
        if (!cursorStack.method_7960()) {
            for (i = beginSlot; i < endSlot; ++i) {
                if (!targetItemStacks.get(i).method_7960()) continue;
                ret.add(i);
                targetItemStacks.set(i, cursorStack.method_7972());
                cursorStack.method_7939(0);
                break;
            }
        }
        return ret;
    }

    private static boolean bothContains(String target, @NotNull String a, @NotNull String b) {
        return a.contains(target) && b.contains(target);
    }

    public static boolean hasTag(class_1799 itemStack) {
        class_9288 data = (class_9288)itemStack.method_57824(class_9334.field_49622);
        if (data != null) {
            return !itemStack.method_7960() && !data.method_57489().toList().isEmpty();
        }
        return false;
    }

    static {
        DYE_COLOR_MAPPING = Maps.newHashMap();
        MAP_COLOR_MAPPING = Maps.newHashMap();
        DYE_COLOR_MAPPING.put(null, 0);
        DYE_COLOR_MAPPING.put(class_1767.field_7952, 1);
        DYE_COLOR_MAPPING.put(class_1767.field_7967, 2);
        DYE_COLOR_MAPPING.put(class_1767.field_7944, 3);
        DYE_COLOR_MAPPING.put(class_1767.field_7963, 4);
        DYE_COLOR_MAPPING.put(class_1767.field_7957, 5);
        DYE_COLOR_MAPPING.put(class_1767.field_7964, 6);
        DYE_COLOR_MAPPING.put(class_1767.field_7946, 7);
        DYE_COLOR_MAPPING.put(class_1767.field_7947, 8);
        DYE_COLOR_MAPPING.put(class_1767.field_7961, 9);
        DYE_COLOR_MAPPING.put(class_1767.field_7942, 10);
        DYE_COLOR_MAPPING.put(class_1767.field_7955, 11);
        DYE_COLOR_MAPPING.put(class_1767.field_7951, 12);
        DYE_COLOR_MAPPING.put(class_1767.field_7966, 13);
        DYE_COLOR_MAPPING.put(class_1767.field_7945, 14);
        DYE_COLOR_MAPPING.put(class_1767.field_7958, 15);
        DYE_COLOR_MAPPING.put(class_1767.field_7954, 16);
        MAP_COLOR_MAPPING.put(null, 0);
        MAP_COLOR_MAPPING.put(class_3620.field_16022, 1);
        MAP_COLOR_MAPPING.put(class_3620.field_15993, 2);
        MAP_COLOR_MAPPING.put(class_3620.field_15978, 3);
        MAP_COLOR_MAPPING.put(class_3620.field_16009, 4);
        MAP_COLOR_MAPPING.put(class_3620.field_15977, 5);
        MAP_COLOR_MAPPING.put(class_3620.field_16020, 6);
        MAP_COLOR_MAPPING.put(class_3620.field_15987, 7);
        MAP_COLOR_MAPPING.put(class_3620.field_16010, 8);
        MAP_COLOR_MAPPING.put(class_3620.field_15997, 9);
        MAP_COLOR_MAPPING.put(class_3620.field_15995, 10);
        MAP_COLOR_MAPPING.put(class_3620.field_16026, 11);
        MAP_COLOR_MAPPING.put(class_3620.field_16024, 12);
        MAP_COLOR_MAPPING.put(class_3620.field_15984, 13);
        MAP_COLOR_MAPPING.put(class_3620.field_16014, 14);
        MAP_COLOR_MAPPING.put(class_3620.field_15998, 15);
        MAP_COLOR_MAPPING.put(class_3620.field_16030, 16);
        MAP_COLOR_MAPPING.put(class_3620.field_16003, 1);
        MAP_COLOR_MAPPING.put(class_3620.field_15988, 2);
        MAP_COLOR_MAPPING.put(class_3620.field_16027, 3);
        MAP_COLOR_MAPPING.put(class_3620.field_16007, 4);
        MAP_COLOR_MAPPING.put(class_3620.field_15992, 5);
        MAP_COLOR_MAPPING.put(class_3620.field_15982, 6);
        MAP_COLOR_MAPPING.put(class_3620.field_15981, 7);
        MAP_COLOR_MAPPING.put(class_3620.field_16013, 8);
        MAP_COLOR_MAPPING.put(class_3620.field_16018, 9);
        MAP_COLOR_MAPPING.put(class_3620.field_16028, 10);
        MAP_COLOR_MAPPING.put(class_3620.field_15990, 11);
        MAP_COLOR_MAPPING.put(class_3620.field_15991, 12);
        MAP_COLOR_MAPPING.put(class_3620.field_16015, 13);
        MAP_COLOR_MAPPING.put(class_3620.field_16029, 14);
        MAP_COLOR_MAPPING.put(class_3620.field_15985, 15);
        MAP_COLOR_MAPPING.put(class_3620.field_15989, 16);
    }

    static class ItemStackComparator
    implements Comparator<class_1799> {
        ItemStackComparator() {
        }

        @Override
        public int compare(class_1799 a, class_1799 b) {
            int aId = SortInventoryHelper.getItemId(a);
            int bId = SortInventoryHelper.getItemId(b);
            if (Configs.sortInventoryShulkerBoxLast.getOptionListValue() == SortInventoryShulkerBoxLastType.ENABLE || Configs.sortInventoryShulkerBoxLast.getOptionListValue() == SortInventoryShulkerBoxLastType.AUTO && !allShulkerBox) {
                if (ShulkerBoxItemHelper.isShulkerBoxBlockItem(a) && !ShulkerBoxItemHelper.isShulkerBoxBlockItem(b)) {
                    return 1;
                }
                if (!ShulkerBoxItemHelper.isShulkerBoxBlockItem(a) && ShulkerBoxItemHelper.isShulkerBoxBlockItem(b)) {
                    return -1;
                }
            }
            class_9288 tagA = (class_9288)a.method_57824(class_9334.field_49622);
            class_9288 tagB = (class_9288)b.method_57824(class_9334.field_49622);
            if (tagA == null || tagB == null) {
                return -1;
            }
            if (ShulkerBoxItemHelper.isShulkerBoxBlockItem(a) && ShulkerBoxItemHelper.isShulkerBoxBlockItem(b) && a.method_7909() == b.method_7909()) {
                return -ShulkerBoxItemHelper.compareShulkerBox(tagA, tagB);
            }
            if (a.method_7909() instanceof class_1747 && b.method_7909() instanceof class_1747) {
                String idb;
                class_2248 blockA = ((class_1747)a.method_7909()).method_7711();
                class_2248 blockB = ((class_1747)b.method_7909()).method_7711();
                if (blockA instanceof IDyeBlock && blockB instanceof IDyeBlock) {
                    return DYE_COLOR_MAPPING.get(((IDyeBlock)blockA).ommc$getColor()) - DYE_COLOR_MAPPING.get(((IDyeBlock)blockB).ommc$getColor());
                }
                String ida = class_7923.field_41175.method_10221((Object)blockA).method_12832();
                if (SortInventoryHelper.bothContains("wool", ida, idb = class_7923.field_41175.method_10221((Object)blockB).method_12832()) || SortInventoryHelper.bothContains("terracotta", ida, idb) || SortInventoryHelper.bothContains("concrete", ida, idb) || SortInventoryHelper.bothContains("candle", ida, idb)) {
                    return MAP_COLOR_MAPPING.getOrDefault(blockA.method_26403(), 0) - MAP_COLOR_MAPPING.getOrDefault(blockB.method_26403(), 0);
                }
            }
            if (a.method_7909() instanceof class_1769 && b.method_7909() instanceof class_1769) {
                return DYE_COLOR_MAPPING.get(((class_1769)a.method_7909()).method_7802()) - DYE_COLOR_MAPPING.get(((class_1769)b.method_7909()).method_7802());
            }
            if (a.method_7960() && !b.method_7960()) {
                return 1;
            }
            if (!a.method_7960() && b.method_7960()) {
                return -1;
            }
            if (a.method_7960()) {
                return 0;
            }
            if (aId == bId) {
                if (!SortInventoryHelper.hasTag(a) && SortInventoryHelper.hasTag(b)) {
                    return 1;
                }
                if (SortInventoryHelper.hasTag(a) && !SortInventoryHelper.hasTag(b)) {
                    return -1;
                }
                if (SortInventoryHelper.hasTag(a)) {
                    return Objects.compare(tagA, tagB, Comparator.comparingInt(class_9288::hashCode));
                }
                return b.method_7947() - a.method_7947();
            }
            return aId - bId;
        }
    }
}

