/*
 * Decompiled with CFR 0.152.
 */
package com.plusls.ommc.impl.generic.highlightWaypoint;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.plusls.ommc.SharedConstants;
import com.plusls.ommc.api.command.ClientBlockPosArgument;
import com.plusls.ommc.game.Configs;
import com.plusls.ommc.impl.generic.highlightWaypoint.HighlightWaypointRenderer;
import com.plusls.ommc.impl.generic.highlightWaypoint.HighlightWaypointResourceLoader;
import com.plusls.ommc.mixin.accessor.AccessorTextComponent;
import com.plusls.ommc.mixin.accessor.AccessorTranslatableComponent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import net.minecraft.class_8828;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.ComponentCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.StyleCompat;
import top.hendrixshen.magiclib.impl.compat.minecraft.world.level.dimension.DimensionWrapper;
import top.hendrixshen.magiclib.util.minecraft.ComponentUtil;

public class HighlightWaypointHandler {
    private static final HighlightWaypointHandler instance = new HighlightWaypointHandler();
    private static final String highlightWaypoint = "highlightWaypoint";
    private static final Pattern pattern = Pattern.compile("(?:(?:x\\s*:\\s*)?(?<x>(?:[+-]?\\d+)(?:\\.\\d+)?)(?:[df])?)(?:(?:(?:\\s*[,\uff0c]\\s*(?:y\\s*:\\s*)?)|(?:\\s+))(?<y>(?:[+-]?\\d+)(?:\\.\\d+)?)(?:[df])?)?(?:(?:(?:\\s*[,\uff0c]\\s*(?:z\\s*:\\s*)?)|(?:\\s+))(?<z>(?:[+-]?\\d+)(?:\\.\\d+)?)(?:[df])?)", 2);
    private final MutablePair<class_2338, class_2338> highlightPos = MutablePair.of(null, null);
    private final HighlightWaypointRenderer renderer = HighlightWaypointRenderer.getInstance();

    public static void init() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)highlightWaypoint).then(ClientCommandManager.argument((String)"pos", (ArgumentType)ClientBlockPosArgument.blockPos()).executes(instance::runCommand))));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> instance.clearHighlightPos());
        HighlightWaypointRenderer.init();
        HighlightWaypointResourceLoader.init();
    }

    private int runCommand(CommandContext<FabricClientCommandSource> context) {
        class_2338 pos = ClientBlockPosArgument.getBlockPos(context, "pos");
        this.setHighlightPos(pos, false);
        return 0;
    }

    @NotNull
    private List<ParseResult> parsePositions(@NotNull String message) {
        ArrayList ret = Lists.newArrayList();
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            ret.add(this.parsePosition(matcher));
        }
        ret.removeIf(Objects::isNull);
        ret.sort(Comparator.comparingInt(ParseResult::getMatcherStart));
        return ret;
    }

    @Nullable
    private ParseResult parsePosition(@NotNull Matcher matcher) {
        Integer x = null;
        int y = 64;
        Integer z = null;
        String xStr = matcher.group("x");
        String yStr = matcher.group("y");
        String zStr = matcher.group("z");
        try {
            x = xStr.contains(".") ? (int)Double.parseDouble(xStr) : Integer.parseInt(xStr);
            z = zStr.contains(".") ? (int)Double.parseDouble(zStr) : Integer.parseInt(zStr);
            if (yStr != null) {
                y = zStr.contains(".") ? (int)Double.parseDouble(yStr) : Integer.parseInt(yStr);
            }
        }
        catch (NumberFormatException e) {
            SharedConstants.getLogger().error("Failed to parse coordinate {}: {}", (Object)matcher.group(), (Object)e);
        }
        if (x == null || z == null) {
            return null;
        }
        return new ParseResult(matcher.group(), new class_2338(x.intValue(), y, z.intValue()), matcher.start());
    }

    public void parseMessage(@NotNull class_2561 chat) {
        chat.method_10855().forEach(this::parseMessage);
        class_7417 contents = ComponentUtil.getTextContent((class_5250)((class_5250)chat));
        if (!(contents instanceof class_2588)) {
            this.updateMessage(chat);
            return;
        }
        Object[] args = ((class_2588)contents).method_11023();
        boolean updateTranslatableText = false;
        for (int i = 0; i < args.length; ++i) {
            class_5250 text;
            if (args[i] instanceof class_2561) {
                this.parseMessage((class_2561)ComponentUtil.simple((Object)((class_2561)args[i]).getString()));
                continue;
            }
            if (!(args[i] instanceof String) || !this.updateMessage((class_2561)(text = ComponentUtil.simple((Object)args[i])))) continue;
            args[i] = text;
            updateTranslatableText = true;
        }
        if (updateTranslatableText) {
            ((AccessorTranslatableComponent)contents).setDecomposedWith(null);
        }
        this.updateMessage(chat);
    }

    private boolean updateMessage(@NotNull class_2561 chat) {
        class_7417 contents = ComponentUtil.getTextContent((class_5250)((class_5250)chat));
        if (!(contents instanceof class_8828.class_2585)) {
            return false;
        }
        class_8828.class_2585 literalChatText = (class_8828.class_2585)contents;
        String message = ((AccessorTextComponent)literalChatText).getText();
        List<ParseResult> positions = this.parsePositions(message);
        if (positions.isEmpty()) {
            return false;
        }
        StyleCompat originalStyle = StyleCompat.of((class_2583)chat.method_10866());
        class_2558 originalClickEvent = ((class_2583)originalStyle.get()).method_10970();
        ArrayList texts = Lists.newArrayList();
        int prevIdx = 0;
        for (ParseResult position : positions) {
            String waypointString = position.getText();
            int waypointIdx = position.getMatcherStart();
            texts.add(ComponentCompat.literalCompat((String)message.substring(prevIdx, waypointIdx)).withStyle(originalStyle));
            class_2338 pos = position.getPos();
            texts.add(ComponentCompat.literalCompat((String)waypointString).withStyle(new class_124[]{class_124.field_1060}).withStyle(new class_124[]{class_124.field_1073}).withStyle(style -> style.method_10958(originalClickEvent == null || Configs.forceParseWaypointFromChat.getBooleanValue() ? new class_2558(class_2558.class_2559.field_11750, String.format("/%s %d %d %d", highlightWaypoint, pos.method_10263(), pos.method_10264(), pos.method_10260())) : originalClickEvent)).withStyle(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)ComponentCompat.literal((String)SharedConstants.getTranslation("highlight_waypoint.tooltip"))))));
            prevIdx = waypointIdx + waypointString.length();
        }
        if (prevIdx < message.length()) {
            texts.add(ComponentCompat.literalCompat((String)message.substring(prevIdx)).withStyle(originalStyle));
        }
        texts.forEach(value -> chat.method_10855().add((class_2561)value.get()));
        ((AccessorTextComponent)literalChatText).setText("");
        ((class_5250)chat).method_27696(StyleCompat.empty());
        return true;
    }

    public void setHighlightPos(@NotNull class_2338 pos, boolean directHighlight) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        boolean posChanged = this.inOverworld((class_1657)player) ? this.setHighlightBlockPos(pos, new class_2338(pos.method_10263() / 8, pos.method_10264(), pos.method_10260() / 8)) : (this.inNether((class_1657)player) ? this.setHighlightBlockPos(new class_2338(pos.method_10263() * 8, pos.method_10264(), pos.method_10260() * 8), pos) : this.setHighlightBlockPos(pos, pos));
        if (directHighlight || !posChanged) {
            this.renderer.lastBeamTime = System.currentTimeMillis() + (long)Configs.highlightBeamTime.getIntegerValue() * 1000L;
        }
    }

    public class_2338 getHighlightPos() {
        class_746 player = class_310.method_1551().field_1724;
        return player == null ? class_2338.field_10980 : this.getHighlightPos((class_1657)player);
    }

    public class_2338 getHighlightPos(class_1657 player) {
        return this.inNether(player) ? (class_2338)this.highlightPos.getRight() : (class_2338)this.highlightPos.getLeft();
    }

    private boolean setHighlightBlockPos(@NotNull class_2338 overworldPos, @NotNull class_2338 netherWorldPos) {
        if (overworldPos.equals(this.highlightPos.getLeft()) && netherWorldPos.equals(this.highlightPos.getRight())) {
            return false;
        }
        this.highlightPos.setLeft((Object)overworldPos);
        this.highlightPos.setRight((Object)netherWorldPos);
        return true;
    }

    public void clearHighlightPos() {
        this.highlightPos.setLeft(null);
        this.highlightPos.setRight(null);
        this.renderer.lastBeamTime = 0L;
    }

    private boolean inOverworld(@NotNull class_1657 player) {
        return DimensionWrapper.of((class_1297)player).equals((Object)DimensionWrapper.OVERWORLD);
    }

    private boolean inNether(@NotNull class_1657 player) {
        return DimensionWrapper.of((class_1297)player).equals((Object)DimensionWrapper.NETHER);
    }

    @Generated
    private HighlightWaypointHandler() {
    }

    @Generated
    public static HighlightWaypointHandler getInstance() {
        return instance;
    }

    public static class ParseResult {
        private final String text;
        private final class_2338 pos;
        private final int matcherStart;

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public class_2338 getPos() {
            return this.pos;
        }

        @Generated
        public int getMatcherStart() {
            return this.matcherStart;
        }

        @Generated
        public ParseResult(String text, class_2338 pos, int matcherStart) {
            this.text = text;
            this.pos = pos;
            this.matcherStart = matcherStart;
        }
    }
}

